////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: yesOrNo() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _YES_OR_NO_T_
#define _YES_OR_NO_T_

#include <global.t>
#include <nestoutcapture.t>

#pragma C+

/*
 *  yesOrNo: function
 *
 *  This is a simple cover function for the built-in function yorn().
 *  This cover function displays any outcaptured display and then 
 *  toggles outcapturing back on.
 */
yesOrNo: function {
    local ret, str;

    /* Capture any outcapture text and display it. */
    str = nestOutcapture(nil, true);
    say(str);

    /* read the input */
    ret = yorn();

    /* if outcapturing was set then reset it. */
    if (global.outptureStatus != nil)
        nestOutcapture(true);
        
    /* return the line of text */
    return ret;
}

#pragma C-

#endif /* _YES_OR_NO_T_ */
