////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: global 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _GLOBAL_T_
#define _GLOBAL_T_

#include <stack.h>

#pragma C+

/*
 *   The "global" object is the dumping ground for any data items that
 *   don't fit very well into any other objects.  The properties of this
 *   object that are particularly important to the objects and functions
 *   are defined here; if you replace this object, but keep other parts
 *   of this file, be sure to include the properties defined here.
 *
 *   Note that awakeTime is set to zero; if you wish the player to start
 *   out tired, just move it up around the sleepTime value (which specifies
 *   the interval between sleeping).  The same goes for lastMealTime; move
 *   it up to around eatTime if you want the player to start out hungry.
 *   With both of these values, the player only starts getting warnings
 *   when the elapsed time (awakeTime, lastMealTime) reaches the interval
 *   (sleepTime, eatTime); the player isn't actually required to eat or
 *   sleep until several warnings have been issued.  Look at the eatDaemon
 *   and sleepDaemon functions for details of the timing.
 */
global: object
    // Command Elements
    actor_  = parserGetMe()
    verb_   = nil
    doList_ = []
    dobj_   = nil
    prep_   = nil
    iobj_   = nil
    status_ = nil
    
    // Command Word Lists and Strings
    cmdWordList_    = []
    cmdString_      = ''
    cmdDoWords      = []
    cmdIoWords      = []
    cantSenseWords  = []
    
    turnSoFar = 0                            // no turns have transpired so far
    score = 0                            // no points have been accumulated yet
    maxScore = 100                                    // maximum possible score
    verbose = nil                             // we are currently in TERSE mode
    textStyleAggregate = true                // controls text aggregation style   
    awakeTime = 0               // time that has elapsed since the player slept
    sleepTime = 400     // interval between sleeping times (longest time awake)
    lastMealTime = 0              // time that has elapsed since the player ate
    eatTime = 200         // interval between meals (longest time without food)

    lampList = [] 
    preparseObjList = []             // list of all known light providers in the game
	timeStatus = nil
	outcaptureStatus = nil
	scopePreActionList = []
	scopePostActionList = []
	scopeEndCommandList = []

	prefixShow = nil
	setPrefixShow(val) = {
	    self.prefixShow = val;
	}
	getPrefixShow = {
	    return self.prefixShow;
	}
	isPrefixShow = {
	    return self.getPrefixShow;
	}
	commandPhase = nil
	commandStage = nil
	setCommandPhase(val) = {
	    switch(val) {
	        case CP_PARSING:
	            self.commandPhase = CP_PARSING;
	            self.commandStage = nil;
	            break;
            case CP_PRECOMMAND:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_PRECOMMAND;
                break;
            case CP_PREACTION:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_PREACTION;
                break;
            case CP_ACTION:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_ACTION;
                break;
            case CP_POSTACTION:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_POSTACTION;
                break;
            case CP_DAEMON:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_DAEMON;
                break;
            case CP_ENDCOMMAND:
                self.commandPhase = CP_EXECUTION;
                self.commandStage = CP_ENDCOMMAND;
	            break;
	    }
	}
	getCommandPhase = {
	    return self.commandPhase;
	}
	getCommandStage = {
	    return self.commandStage;
	}
	isCommandPhase(val) = {
	    if (self.getCommandPhase == val)
	        return true;
        else
            return nil;
	}
	isCommandStage(val) = {
	    if (self.getCommandStage == val)
	        return true;
        else
            return nil;
	}
;

#pragma C-

#endif /* _GLOBAL_T_ */
