////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: theFloor 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _THE_FLOOR_T_
#define _THE_FLOOR_T_

#include <floating.h>
#include <beditem.h>

#pragma C+

/*
 *  theFloor is a special item that appears in every room (hence
 *  the non-standard location property).  This object is included
 *  mostly for completeness, so that the player can refer to the
 *  floor; otherwise, it doesn't do much.  Dropping an item on the
 *  floor, for example, moves it to the current room.
 */
theFloor: Floating, BedItem
    noun = 'floor' 'ground'
    sDesc = "ground"
    lDesc = "It lies beneath you. "
    aDesc = "the ground"
    boardingPosture = lying
    foundIn = {
        if (parserGetMe().location == self)
            return self.sitLoc;
        else
            return parserGetMe().location;
    }
    doSiton(actor) = {
        self.sitLoc = actor.location;
        actor.moveInto(self);
        actor.posture = sitting;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    doLieon(actor) = {
        self.sitLoc = actor.location;
        actor.moveInto(self);
        actor.posture = lying;
        "Okay, %you're% now <<actor.posture.desc>> 
        <<self.boardingPrep>> <<self.theDesc>>. ";
    }
    ioPutOn(actor, dobj) = {
        dobj.doDrop(actor);
    }
    ioPutIn(actor, dobj) = {
        dobj.doDrop(actor);
    }
    ioThrowAt(actor, dobj) = {
        "Thrown. ";
        dobj.moveInto(actor.location);
    }
;

#pragma C-

#endif /* _THE_FLOOR_T_ */
