////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: StdIF 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef __STD_IF_H_
#define __STD_IF_H_

/*
 *   Set a flag indicating that we want to use the HTML version of the
 *   status line code.  This must be set before we include adv.t, because
 *   adv.t needs to know what kind of status line we want. 
 */
#define USE_HTML_STATUS

/*
 *   Set another flag, this time indicating that we want to use the HTML
 *   version of the command prompt display code.  This code is in std.t,
 *   so we must define this flag before we include std.t.  
 */
#define USE_HTML_PROMPT

/* Constants */
#include <constants.h>

/* Functions */
#include <functions.h>

/* Classes */
#include <classes.h>

/* Grammar */
#include <grammar.h>

/* Objects */
#include <objects.h>

#pragma C-

#endif /* __STD_IF_H_ */
