dynamicgrid: object
    create( cls, loc, dir ) = {
        local linkobj, o, prop, dx, dy, dz, ret;
        local x := loc.(cls.xposProp) + cls.xconvert( dir );
        local y := loc.(cls.yposProp) + cls.yconvert( dir );
        local z := loc.(cls.zposProp) + cls.zconvert( dir );
        if (cls.approve( x, y, z, loc, dir )) {
            o := cls.create( x, y, z, loc, dir );
            for (linkobj := firstobj( cls ); linkobj; linkobj := nextobj( linkobj, cls )) {
              dx := linkobj.(cls.xposProp) - x;
              if (dx <= 1 and dx >= -1) {
                dy := linkobj.(cls.yposProp) - y;
                if (dy <= 1 and dy >= -1) {
                  dz := linkobj.(cls.zposProp) - z;
                  if (dz <= 1 and dz >= -1) {
                    prop := cls.translateProp( dx, dy, dz );
                    if (prop) ret := o.dynamicLinkTo( linkobj, prop, dx, dy, dz, cls );
                    else continue;
                    if (ret) {
                      prop := cls.translateProp( -dx, -dy, -dz );
                      if (prop) linkobj.dynamicLinkTo( o, prop, -dx, -dy, -dz, cls );
                    }
                  }
                }
              }
            }
            return nil;
        }
        else return true;
    }
;

class dynamicgridclass: room
    translateProp( dx, dy, dz ) = {
        if (dz <> 0) {
            if (dx <> 0 or dy <> 0) return nil;
            else return (dz = 1 ? &up : &down );
        }
        else {
            switch (dx) {
              case -1:
                switch (dy) {
                  case -1: return &sw;
                  case 0: return &west;
                  case 1: return &nw;
                }
              case 0:
                switch (dy) {
                  case -1: return &south;
                  case 0: return nil;
                  case 1: return &north;
                }
              case 1:
                switch (dy) {
                  case -1: return &se;
                  case 0: return &east;
                  case 1: return &ne;
                }
            }
        }
    }
    xconvert( dir ) = {
        switch (dir) {
          case &nw: case &sw: case &west: return -1;
          case &ne: case &se: case &east: return 1;
          default: return 0;
        }
    }
    yconvert( dir ) = {
        switch (dir) {
          case &nw: case &ne: case &north: return 1;
          case &sw: case &se: case &south: return -1;
          default: return 0;
        }
    }
    zconvert( dir ) = {
        switch (dir) {
          case &up: return 1;
          case &down: return -1;
          default: return 0;
        }
    }
    approve( x, y, z, loc, dir ) = true
    create( x, y, z, loc, dir ) = {
        local o := new self;
        o.(self.xposProp) := x;
        o.(self.yposProp) := y;
        o.(self.zposProp) := z;
        o.initiate;
        return o;
    }
    construct = {}
    dynamicLookup( x, y, z ) = {
        local o;
        for (o := firstobj( self ); o; o := nextobj( o, self ))
            if (o.(self.xposProp) = x and o.(self.yposProp) = y and
                o.(self.zposProp) = z) return o;
        return nil;
    }
;

modify room
    dynamicLinkTo( obj, dir, dx, dy, dz, cls ) = {
        self.(dir) := obj;
        return true;
    }
;
