writeMenu : function;

/*
writeMenu: function( cls, ... ) {
  local lvl := 1, lst, len, i, keys := [], k := nil, parm;
  switch (argcount) {
    case 3: parm := getarg( 3 );
    case 2: lvl := getarg( 2 );
  }
  lst := gac( cls, &disallowMenu, nil, parm );
  lst := lst[1].orderMenu( lst, lvl, parm );
  len := length( lst );
  for (i := 1; i <= len; ++i) keys += lst[i].menuKeys;
#ifdef __DEBUG
  keys += '$';
#endif
  while (true) {
    "\b"; cls.dispMenu( lvl, parm, lst );
    if (lst[1].menuKeyed) {
        "\n"; lst[1].menuPrompt;
        while (find( keys, k ) = nil) {
            k := inputkey();
            if (not cls.menuCaseSensitive) k := lower( k );
        }
    }
    else {
        while (find( keys, k ) = nil) {
            "\n"; lst[1].menuPrompt;
            k := input();
            if (not cls.menuCaseSensitive) k := lower( k );
        }
    }
#ifdef __DEBUG
    if (k = '$') return true;
#endif
    for (i := 1; i <= len; ++i) {
        if (find( lst[i].menuKeys, k )) {
            if (lst[1].menuKeyed) say( k );
            k := lst[i].menuAction( cls, lvl, parm );
            break;
        }
    }
    if (k = true) return true;
    else if (datatype( k ) = TYPE_NUMBER and k > 0) return (k - 1);
    k := nil;
  }
} */

writeMenu: function( cls, ... ) {
  local lvl := 1, lst, len, i, keys := [], k := nil, parm, stayin;
  local app, capp;
  switch (argcount) {
    case 3: parm := getarg( 3 );
    case 2: lvl := getarg( 2 );
  }
  lst := gac( cls, &disallowMenu, nil, parm );
  lst := lst[1].orderMenu( lst, lvl, parm );
  len := length( lst );
  while (true) {
    "\b"; cls.dispMenu( lvl, parm, lst );
    if (lst[1].menuKeyed) {
        for (i := 1; i <= len; ++i) keys += lst[i].menuKeys;
#ifdef __DEBUG
        keys += '$';
#endif
        "\n"; lst[1].menuPrompt;
        while (find( keys, k ) = nil) {
            k := inputkey();
            if (not cls.menuCaseSensitive) k := lower( k );
        }
#ifdef __DEBUG
        if (k = '$') return true;
#endif
        for (i := 1; i <= len; ++i) {
          if (find( lst[i].menuKeys, k )) {
            say( k );
            k := lst[i].menuAction( cls, lvl, parm );
            break;
          }
        }
    }
    else {
      stayin := true;
      while (stayin) {
        "\n"; lst[1].menuPrompt;
        k := input();
#ifdef __DEBUG
        if (k = '$') return true;
#endif
        if (not cls.menuCaseSensitive) k := lower( k );
        app := []; capp := [];
        for (i := 1; i <= len; ++i) {
            keys := lst[i].checkKey( k, cls, lvl, parm );
            if (keys = true) app += lst[i];
            else if (keys = 1) capp += lst[i];
        }
        if (length( app ) = 1) {
            k := app[1].menuAction( cls, lvl, parm );
            stayin := nil;
        }
        else if (length( app ) = 0 and length( capp ) = 1) {
            k := capp[1].menuAction( cls, lvl, parm );
            stayin := nil;
        }
      }
    }
    if (k = true) return true;
    else if (datatype( k ) = TYPE_NUMBER and k > 0) return (k - 1);
    k := nil;
  }
}

class Menu: object
    menuAction( cls, lvl, parm ) = {
        if (self.menuList <> []) {
          local v := find( self.menuList, self.value );
          if (v) {
            v++;
            if (v > length( self.menuList)) v := 1;
            self.value := self.menuList[ v ];
          }
        }
        return nil;
    }
    menuCaseSensitive = nil
    menuClear = nil
    menuDesc = ""
    menuKeyed = nil
    menuKeys = []
    menuList = []
    menuPrompt = "?"
    menuTitle = ""
    orderMenu( lst, lvl, parm ) = {
        if (lvl = 1) return (lst + menuQuit);
        else return (lst + menuBack + menuQuit);
    }
    dispMenuItem( cls, lvl, ind, parm ) = {
        "\n\t";        
        self.menuDesc;
    }
    dispMenu( lvl, parm, lst ) = {
        local len := length( lst ), i;
        if (self.menuClear) clearscreen();
        "\t\t"; self.menuTitle;
        for (i := 1; i <= len; ++i) lst[i].dispMenuItem( self, lvl, i, parm );
    }
    checkKey( key, cls, lvl, parm ) = {
        if (find( self.menuKeys, key )) return true;
        else return nil;
    }
;

menuQuit: Menu
    menuAction( cls, lvl, parm ) = true
    menuDesc = "\(Q\)uit"
    menuKeys = [ 'quit' 'q' ]
;

menuBack: Menu
    menuAction( cls, lvl, parm ) = 1
    menuDesc = "\(B\)ack"
    menuKeys = [ 'back' 'b' ]
;
