/*
** Uninstal.c, a quick-and-dirty uninstaller for WinTADS
*/

#define CCHMAXPATH 500

#include <windows.h>
#include "uninstal.h"

CHAR	pszHomePath[CCHMAXPATH],
		szAppName[] = "Uninstall";

HFONT	hFontSerif;

LRESULT CALLBACK UninstallWndProc(HWND, UINT, WPARAM, LPARAM);
VOID DisplayMessage(PSZ pszString);
VOID DisplayInformation(PSZ pszString);
VOID DisplayError(PSZ pszString);

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
	int nCmdShow)
{
	MSG			msg;
	HWND		hwnd;
	WNDCLASS	wcx;
	PCHAR		p;
	DWORD		d;

	if (!hPrevInstance) {
		wcx.style = CS_HREDRAW | CS_VREDRAW;
		wcx.lpfnWndProc = (WNDPROC)UninstallWndProc;
		wcx.cbClsExtra = 0;
		wcx.cbWndExtra = DLGWINDOWEXTRA;
		wcx.hInstance = hInstance;
		wcx.hIcon = LoadIcon(hInstance, szAppName);
		wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
		wcx.hbrBackground = GetStockObject(LTGRAY_BRUSH);
		wcx.lpszMenuName = NULL;
		wcx.lpszClassName = szAppName;
		
		if (!RegisterClass(&wcx)) {
			d = GetLastError();
			DisplayError("Unable to register Uninstall window class");
			return FALSE;
		}
	}

	hwnd = CreateDialog(hInstance, szAppName, 0, NULL);

	// Find the initial path
	GetModuleFileName(NULL, pszHomePath, CCHMAXPATH);
	p = pszHomePath + strlen(pszHomePath) - 2;
	while (p != pszHomePath && *p != '\\')
		p--;
	if (p != pszHomePath)
		*(p+1) = 0;

	// Set up the font
	hFontSerif = CreateFont(14, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0,
		VARIABLE_PITCH | FF_SWISS, "");

	ShowWindow(hwnd, nCmdShow);
	
	PostMessage(hwnd, WM_COMMAND, CMD_SETUP, 0);
	
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	DeleteObject(hFontSerif);

	return msg.wParam;
}

LONG APIENTRY UninstallWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CHAR		szValue1[2][10] = { ".gam", ".sav" },
				szValue2[2][50] = { "TADS game file", "TADS saved game" },
				szValue3[] = "DefaultIcon",
				szValue4[3][10] = { "shell", "open", "command" };
	HKEY		key[3];
	PCHAR		p;
	INT			i, j;

	switch (msg) {
	  case WM_DESTROY:
		PostQuitMessage(0);
		return 0;

	  case WM_DRAWITEM: {
		HWND	hCtrl = GetDlgItem(hwnd, (UINT)wParam);
		HDC		hdc = GetDC(hCtrl);
		RECT	rect;
		HBRUSH	hBrush;
		HFONT	hFontTmp;
		int		len;
		char	szText[500];
		
		GetClientRect(hCtrl, &rect);
		hBrush = CreateSolidBrush(GetSysColor(COLOR_3DFACE));
		FillRect(hdc, &rect, hBrush);
		DeleteObject(hBrush);
		if (len = GetWindowText(hCtrl, szText, sizeof(szText))) {
			SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
			SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));
			hFontTmp = SelectObject(hdc, hFontSerif);
			ExtTextOut(hdc, rect.left, rect.top,
				ETO_OPAQUE | ETO_CLIPPED,
				&rect,
				(LPSTR)szText,
				len, NULL);
			SelectObject(hdc, hFontTmp);
		}
		}
		return TRUE;

	  case WM_COMMAND:
		switch (wParam) {
		  case IDOK:
			PostMessage(hwnd, WM_CLOSE, 0, 0);
			return TRUE;

		  case CMD_SETUP:
			SetDlgItemText(hwnd, IDD_TXT, "Uninstall is currently");
			SetDlgItemText(hwnd, IDD_STATUS, "preparing for uninstallation.");
			SendDlgItemMessage(hwnd, IDD_PROGRESS, PBM_SETRANGE,
				0, MAKELPARAM(0, 100));
			SendDlgItemMessage(hwnd, IDD_PROGRESS, PBM_SETSTEP,
				20, 0);
			PostMessage(hwnd, WM_COMMAND, CMD_WIPE1, 0);
			SetDlgItemText(hwnd, IDD_STATUS, "removing Registry keys.");
			break;
			
		  case CMD_WIPE1:
			Sleep(250);
			
			// Remove the registry strings
			i = (int)lParam;
			RegDeleteKey(HKEY_CLASSES_ROOT, szValue1[i]);
			p = szValue2[i];
			if (RegOpenKeyEx(HKEY_CLASSES_ROOT, p, 0, KEY_ALL_ACCESS,
				&key[0]) != ERROR_SUCCESS)
				goto kludge_jump;
			RegDeleteKey(key[0], szValue3);
			for (j = 0; j < 2; j++)
				RegOpenKeyEx(key[j], szValue4[j], 0, KEY_ALL_ACCESS,
					&key[j+1]);
			for (j = 2; j > 0; j--) {
				RegDeleteKey(key[j], szValue4[j]);
				RegCloseKey(key[j]);
			}
			RegDeleteKey(key[0], szValue4[0]);
			RegCloseKey(key[0]);
			RegDeleteKey(HKEY_CLASSES_ROOT, p);

kludge_jump:
			SendDlgItemMessage(hwnd, IDD_PROGRESS, PBM_STEPIT, 0, 0);
			if (i < 2)
				PostMessage(hwnd, WM_COMMAND, CMD_WIPE1, i+1);
			else {
				PostMessage(hwnd, WM_COMMAND, CMD_WIPE2, 0);
				SetDlgItemText(hwnd, IDD_STATUS,
					"deleting program and documentation files.");
			}
			break;
			
		  case CMD_WIPE2: {
			char	szFile[CCHMAXPATH];

			Sleep(250);
			i = (int)lParam;
			if (i == 0) {
				strcpy(szFile, pszHomePath);
				strcat(szFile, "wintads.exe");
				DeleteFile(szFile);
				strcpy(szFile, pszHomePath);
				strcat(szFile, "wintads.ini");
				DeleteFile(szFile);
			}
			else {
				strcpy(szFile, pszHomePath);
				strcat(szFile, "history.txt");
				DeleteFile(szFile);
				strcpy(szFile, pszHomePath);
				strcat(szFile, "wintads.doc");
				DeleteFile(szFile);
				strcpy(szFile, pszHomePath);
				strcat(szFile, "uninstal.exe");
				DeleteFile(szFile);
			}
			}
			SendDlgItemMessage(hwnd, IDD_PROGRESS, PBM_STEPIT, 0, 0);
			if (i == 0)
				PostMessage(hwnd, WM_COMMAND, CMD_WIPE2, 1);
			else PostMessage(hwnd, WM_COMMAND, CMD_ALLDONE, 0);
			break;
		  	
		  case CMD_ALLDONE:
			SetDlgItemText(hwnd, IDD_STATUS,
				"finished. Select \"OK\" to quit.");
			EnableWindow(GetDlgItem(hwnd, IDOK), TRUE);
			break;
		}
	}

	return DefWindowProc(hwnd, msg, wParam, lParam);
}

VOID DisplayMessage(PSZ pszString)
{
	MessageBox(GetFocus(), pszString, "Uninstall Message",
		MB_OK);
}

VOID DisplayInformation(PSZ pszString)
{
	MessageBeep(MB_ICONASTERISK);
	MessageBox(GetFocus(), pszString, "Uninstall Information",
		MB_ICONINFORMATION | MB_OK);
}

VOID DisplayError(PSZ pszString)
{
	MessageBeep(MB_ICONEXCLAMATION);
	MessageBox(GetFocus(), pszString, "Uninstall Error",
		MB_ICONERROR | MB_OK);
}
