//
//  XTTableColumnWidthTracker.h
//  XTads
//
//  Created by Rune Berg on 07/09/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextTableBlock.h"
#import "XTTextTableBlockCaption.h"


@interface XTTableDimensionsTracker : NSObject

+ (id)tracker;

- (NSNumber *)registerNewTable;

- (void)noteMaxContentRectWidthForTable:(NSNumber *)tableId
						 textTableBlock:(XTTextTableBlock *)textTableBlock
								  width:(CGFloat)width;

- (void)noteMinContentRectWidthForTable:(NSNumber *)tableId
						 textTableBlock:(XTTextTableBlock *)textTableBlock
								  width:(CGFloat)width;

- (CGFloat)minContentRectWidthForTable:(NSNumber *)tableId
						textTableBlock:(XTTextTableBlock *)textTableBlock;

- (void)noteMinContentRectHeightForTable:(NSNumber *)tableId
						  textTableBlock:(XTTextTableBlock *)textTableBlock
								   height:(CGFloat)height;

- (void)noteTotalBoundsForTable:(NSNumber *)tableId
				 textTableBlock:(XTTextTableBlock *)textTableBlock
						  width:(CGFloat)width
						 height:(CGFloat)height;

- (void)noteBoundsRectForTable:(NSNumber *)tableId
				textTableBlock:(XTTextTableBlock *)textTableBlock
						 width:(CGFloat)width
						height:(CGFloat)height;

- (void)noteHorizRulerWidthAsPoints:(NSNumber *)tableId
					 textTableBlock:(XTTextTableBlock *)textTableBlock
							  width:(CGFloat)width;

- (CGFloat)contentRectWidthForTable:(NSNumber *)tableId
					 textTableBlock:(XTTextTableBlock *)textTableBlock
						usableWidth:(CGFloat)usableWidth;

- (CGFloat)contentRectWidthForTable:(NSNumber *)tableId
					 textTableBlockCaption:(XTTextTableBlockCaption *)textTableBlock
						usableWidth:(CGFloat)usableWidth;

- (CGFloat)contentRectHeightForTable:(NSNumber *)tableId
					  textTableBlock:(XTTextTableBlock *)textTableBlock
					   visibleHeight:(CGFloat)visibleHeight;

- (CGFloat)contentRectXForTable:(NSNumber *)tableId
				 textTableBlock:(XTTextTableBlock *)textTableBlock
						originX:(CGFloat)originX
					usableWidth:(CGFloat)usableWidth;

- (CGFloat)totalTableWidth:(NSNumber *)tableId;

- (void)clearAll;

- (void)clearForRecalcOfTables;

- (void)noteMinCaptionContentRectWidthForTable:(NSNumber *)tableId
										 width:(CGFloat)width;

@end
