//
//  XTFormattedElementQueue.m
//  XTads
//
//  Created by Rune Berg on 29/05/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTFormattedElementQueue.h"
#import "XTAllocDeallocCounter.h"


@interface XTFormattedElementQueue ()

@property NSMutableArray *queue;
	//TODO !!! find a more efficient FIFO class

@end


@implementation XTFormattedElementQueue

- (instancetype)init
{
	self = [super init];
	if (self) {
		_queue = [NSMutableArray arrayWithCapacity:100];
	}
	return self;
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (void) addObjectsFromArray:(NSArray *)formattedElements
{
	[self.queue addObjectsFromArray:formattedElements];
}

- (BOOL)isEmpty
{
	return (self.queue.count == 0);
}

- (NSUInteger)count
{
	NSUInteger res = self.queue.count;
	return res;
}

- (XTFormattedOutputElement *)removeFirst
{
	XTFormattedOutputElement *res = nil;
	if (! [self isEmpty]) {
		res = [self.queue objectAtIndex:0];
		[self.queue removeObjectAtIndex:0];
	}
	return res;
}


@end
