//
//  XTUIUtils.h
//  TadsTerp
//
//  Created by Rune Berg on 29/09/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface XTUIUtils : NSObject

typedef NS_ENUM(NSInteger, XTadsInputDialogIconId) {
	XTadsInputDialogIconIdNone,
	XTadsInputDialogIconIdWarning,
	XTadsInputDialogIconIdInfo,
	XTadsInputDialogIconIdQuestion,
	XTadsInputDialogIconIdError
};

+ (void)showModalErrorDialogInWindow:(NSWindow *)window
						 messageText:(NSString *)messageText;

+ (BOOL)confirmAbortRunningGameInWindow:(NSWindow *)window
							messageText:(NSString *)messageText
						informativeText:(NSString *)informativeText
			  continuePlayingButtonText:(NSString *)continuePlayingButtonText
				  quitPlayingButtonText:(NSString *)quitPlayingButtonText;

+ (NSInteger)runModalSheet:(NSAlert *)sheet forWindow:(NSWindow *)aWindow;

+ (NSURL *)runModalOpenDirectorySheetForWindow:(NSWindow *)window
						   defaultDirectoryUrl:(NSURL *)defaultDirectoryUrl;

+ (BOOL)buttonHasKeyEquiv:(NSButton *)button;

+ (NSUInteger)runModalInputDialogForWindow:(NSWindow *)window
									 title:(NSString *)title
					   standardButtonSetId:(NSUInteger)standardButtonSetId
						 customButtomSpecs:(NSArray *)customButtomSpecs
							  defaultIndex:(NSUInteger)defaultIndex
							   cancelIndex:(NSUInteger)cancelIndex
									iconId:(XTadsInputDialogIconId)iconId;

+ (NSOpenPanel *)makeFileOpenPanelWithTitle:(NSString *)title
						  allowedExtensions:(NSArray *)allowedExtensions
								 defaultDir:(NSURL *)defaultDir;

+ (NSSavePanel *)makeFileSavePanelWithTitle:(NSString *)title
						  allowedExtensions:(NSArray *)allowedExtensions
								 defaultDir:(NSURL *)defaultDir
							defaultBasename:(NSString *)defaultBasename;

+ (NSScrollView*)createScrollViewWithTextViewForMainOutputArea:(id<NSTextViewDelegate>)textViewDelegate;

@end
