//
//  XTGameInputEvent.m
//  XTads
//
//  Created by Rune Berg on 19/10/16.
//  Copyright © 2016 Rune Berg. All rights reserved.
//

#import "XTGameInputEvent.h"
#import "XTAllocDeallocCounter.h"
#include "os.h"


@implementation XTGameInputEvent

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (id)init
{
	self = [super init];
	if (self) {
		_type = OS_EVT_NONE;
		_key0 = 0;
		_key1 = 0;
		_href = nil;
		_commandId = OS_CMD_NONE;
	}
	return self;
}

- (void)reset
{
	self.type = OS_EVT_NONE;
	self.key0 = 0;
	self.key1 = 0;
	self.href = nil;
	self.commandId = OS_CMD_NONE;
}

- (void)setFrom:(XTGameInputEvent *)other
{
	self.type = other.type;
	self.key0 = other.key0;
	self.key1 = other.key1;
	self.href = other.href;
	self.commandId = other.commandId;
}

@end
