//
//  XTHtmlTagP.m
//  TadsTerp
//
//  Created by Rune Berg on 30/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagP.h"
#import "XTHtmlTag_private.h"
#import "XTHtmlUtils.h"
#import "XTFormattingSpecificationForHtmlTag.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagP

+ (NSString *)name
{
	return @"p";
}

+ (BOOL)standalone
{
	return NO;
}

- (BOOL)blockLevel
{
	return YES;
}

- (BOOL)blockLevelSpacingBefore
{
	return YES;
}

- (BOOL)blockLevelSpacingAfter
{
	return NO;
}

- (XTTextAlignMode)getTextAlignModeFrom:(XTTextAlignMode)currentTextAlignMode
{
	XTTextAlignMode defaultTextAlignMode = XT_TEXT_ALIGN_LEFT;
	if ([self shouldInheritHorizAlignmentFromContainer]) {
		defaultTextAlignMode = currentTextAlignMode;
	}
	XTTextAlignMode res = [self getTextAlignModeWithDefault:defaultTextAlignMode];
	return res;
}

- (BOOL)shouldInheritHorizAlignmentFromContainer
{
	return [XTHtmlUtils tagIsEnclosedByDivOrCenter:self];
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements;
	if (! self.closing) {
		formattedElements = [formatter handleHtmlTagPOpen:self];
	} else {
		formattedElements = [formatter handleHtmlTagPClose:self];
		if (! [self shouldInheritHorizAlignmentFromContainer]) {
			formatter.formattingSpecForHtmlTag.formattingSpec.textAlignMode = XT_TEXT_ALIGN_LEFT;
		}
	}
	[textHandler receiveFormattedElements:formattedElements];
}

- (void)onEndTag:(NSObject<XTOutputTextParserProtocol> *)parser
{
	[parser appendTagToCurrentContainer:self];
}

@end
