//
//  XTLogAppenderBase.m
//  TadsTerp
//
//  Created by Rune Berg on 15/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTLogAppenderBase.h"
#import "XTLoggerLevel.h"


@implementation XTLogAppenderBase

static NSDictionary *levelNameByLevel;

+ (void)initialize
{
	levelNameByLevel = @{
	   [NSNumber numberWithInteger:XT_LEVEL_TRACE] : XT_LEVEL_LETTER_TRACE,
	   [NSNumber numberWithInteger:XT_LEVEL_DEBUG] : XT_LEVEL_LETTER__DEBUG,
	   [NSNumber numberWithInteger:XT_LEVEL_INFO]  : XT_LEVEL_LETTER_INFO,
	   [NSNumber numberWithInteger:XT_LEVEL_WARN]  : XT_LEVEL_LETTER_WARN,
	   [NSNumber numberWithInteger:XT_LEVEL_ERROR] : XT_LEVEL_LETTER_ERROR,
	   [NSNumber numberWithInteger:XT_LEVEL_FATAL] : XT_LEVEL_LETTER_FATAL
	};
}

- (NSString *)nameForLevel:(XTLoggerLevel)level
{
	NSString *res = levelNameByLevel[[NSNumber numberWithInteger:level]];
	if (res == nil) {
		res = @"?";
	}
	return res;
}

@end
