//
//  XTUserOptions.h
//  TadsTerp
//
//  Created by Rune Berg on 17/09/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface XTPrefs : NSObject

typedef NS_ENUM(NSInteger, XTPrefsDirectoryMode) {
	XTPREFS_DIR_MODE_NONE,
	XTPREFS_DIR_MODE_SPECIFIC,
	XTPREFS_DIR_MODE_LAST_SELECTED,
	XTPREFS_DIR_MODE_CURRENT_GAMEFILE
};

typedef NS_ENUM(NSInteger, XTPrefsFileNameMode) {
	XTPREFS_FILENAME_MODE_UNTITLED,
	XTPREFS_FILENAME_MODE_GAMENAME_DATETIME
};

typedef NS_ENUM(NSInteger, XTPrefsIOSafetyMode) {
	XTPREFS_IO_SAFETY_MODE_NO_ACCESS,
	XTPREFS_IO_SAFETY_MODE_GAME_DIR_ONLY,
	XTPREFS_IO_SAFETY_MODE_ANYWHERE
};

typedef NS_ENUM(NSInteger, XTPrefsGameWindowStartMode) {
	XTPREFS_GAME_WINDOW_SAME_AS_LAST,
	XTPREFS_GAME_WINDOW_NICE_IN_MIDDLE,
	XTPREFS_GAME_WINDOW_WHATEVER
};

#define XTPREFS_SCROLLBACK_BUFFER_SIZE_50KB 50
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_100KB 100
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_200KB 200
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_500KB 500
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_1000KB 1000
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_2000KB 2000
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_5000KB 5000

//TODO ! why this mix of primitive and object types for number stuff

@property XTPrefsDirectoryMode gamesDirectoryMode;
@property NSURL *gamesDirectoryWhenSpecific;
@property NSURL *gamesDirectoryLastUsed;

@property XTPrefsDirectoryMode savesDirectoryMode;
@property NSURL *savesDirectoryWhenSpecific;
@property NSURL *savesDirectoryLastUsed;
@property XTPrefsFileNameMode savesFileNameMode;

@property XTPrefsDirectoryMode transcriptsDirectoryMode;
@property NSURL *transcriptsDirectoryWhenSpecific;
@property NSURL *transcriptsDirectoryLastUsed;
@property XTPrefsFileNameMode transcriptsFileNameMode;

@property XTPrefsDirectoryMode commandScriptsDirectoryMode;
@property NSURL *commandScriptsDirectoryWhenSpecific;
@property NSURL *commandScriptsDirectoryLastUsed;
@property XTPrefsFileNameMode commandScriptsFileNameMode;

@property NSString *defaultFontName;
@property NSNumber *defaultFontSize;
@property NSString *defaultFontDescription;

@property NSString *fixedWidthFontName;
@property NSNumber *fixedWidthFontSize;
@property NSString *fixedWidthFontDescription;

@property NSString *serifedFontName;
@property NSNumber *serifedFontSize;
@property NSString *serifedFontDescription;

@property NSString *sansSerifFontName;
@property NSNumber *sansSerifFontSize;
@property NSString *sansSerifFontDescription;

@property NSString *scriptFontName;
@property NSNumber *scriptFontSize;
@property NSString *scriptFontDescription;

@property NSString *typewriterFontName;
@property NSNumber *typewriterFontSize;
@property NSString *typewriterFontDescription;

@property NSNumber *inputFontIsSameAsDefaultFont;
@property NSString *inputFontName;
@property NSNumber *inputFontSize;
@property NSNumber *inputFontUsedEvenIfNotRequestedByGame;
@property NSString *inputFontDescription;

@property NSNumber *statusLineFontIsSameAsDefaultFont;
@property NSString *statusLineFontName;
@property NSNumber *statusLineFontSize;
@property NSString *statusLineFontDescription;

@property NSNumber *allowGamesToSetFonts;
@property NSNumber *minAllowedFontSize;
@property NSNumber *maxAllowedFontSize;

@property NSColor *statusLineTextColor;
@property NSColor *statusLineBackgroundColor;

@property NSColor *outputAreaTextColor;
@property NSColor *outputAreaBackgroundColor;

@property NSColor *inputTextColor;

@property NSColor *linksTextColor;
@property NSNumber *linksUnderline;
@property NSNumber *linksShowToolTips;

@property NSNumber *allowGamesToSetFontColors;
@property NSNumber *allowGamesToSetBackgroundColors;

@property XTPrefsGameWindowStartMode gameWindowStartMode;

@property XTPrefsIOSafetyMode readSafetyMode;
@property XTPrefsIOSafetyMode writeSafetyMode;

@property NSNumber *askForGameFileOnTerpStart;
@property NSNumber *printTadsBannerOnGameStart;
@property NSNumber *askForConfirmationOnGameRestart;
@property NSNumber *askForConfirmationOnGameQuit;
@property NSNumber *askForConfirmationOnGameOpenIfGameRunning;
@property NSNumber *enableDevelopmentModeFeatures;
@property NSNumber *limitScrollbackBufferSize; // whether to limit or not
@property NSNumber *scrollbackBufferSizeInKBs; // the actual limit, in kilobytes
@property NSNumber *tads2Encoding;
@property NSNumber *tads2EncodingOverride;

@property NSNumber *printBrokenHtmlMarkup;
@property NSNumber *showParserMode;
@property NSNumber *spellCheckGameText;
@property NSNumber *grammarCheckGameText;

@property BOOL alwaysFalse;
@property NSNumber *minMinAllowedFontSize;
@property NSNumber *maxMaxAllowedFontSize;


// get singleton instance
+ (id) prefs;

- (void)cleanupUnused;

- (void)registerMissing;

- (void)restoreFromPersisted;

- (void)persist;

- (void)resetDefaultFonts;
- (void)resetDefaultDirsAndFiles;
- (void)resetDefaultColors;
- (void)resetDefaultLayout;
- (void)resetDefaultIOSafetyModes;
- (void)resetDefaultMisc;
- (void)resetDefaultDevMode;

- (void)startObservingChangesToAll:(NSObject *)observer;
- (void)stopObservingChangesToAll:(NSObject *)observer;
- (void)startObservingChangesToColors:(NSObject *)observer;
- (void)stopObservingChangesToColors:(NSObject *)observer;
- (void)startObservingChangesToFonts:(NSObject *)observer;
- (void)stopObservingChangesToFonts:(NSObject *)observer;

- (void)updateDefaultFontWithName:(NSString *)name size:(CGFloat)zize;
- (void)updateFixedWidthFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateSerifedFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateSansSerifFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateScriptFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateTypewriterFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateInputFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateStatusLineFontWithName:(NSString *)name size:(CGFloat)size;

@end
