#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Diagnostic.t
 *
 *  Provides meta-commands for diagnostic purposes.
 */

#include "adv3.h"
#include "tok.h"
#include "en_us.h"
#include "proteus.h"

/*
 *  We add new token rules for metacommands, such as '@show'; for 
 *  object reference tags, such as 'tads#4e0'; and for symbolics 
 *  that might contain underlines, such as tmpAmbient_'.
 */
proteusRefTagTokenRuleObject: TokenRuleObject
{
    tokRule_    = ['proteusRefTagTokenRuleObject', 
        new RexPattern('<Alpha>(<AlphaNum>)*[#](<AlphaNum>)+'), 
        tokWord, nil, nil]
    tokStrList_ = ['tads#5e9', 'tads#61b', 'tads#f12']
}
proteusUnderlineTokenRuleObject: TokenRuleObject
{
    tokRule_    = ['proteusUnderlineTokenRuleObject', 
        new RexPattern('<Alpha|-|_|@><AlphaNum|-><AlphaNum|-|_>*'), 
        tokWord, nil, nil]
    tokStrList_ = ['tmpTrans_', 'tmp_trans', '_tmpTrans', '_tmp_Trans', 
        'tmp_Trans_', '_tmp_Trans_', '@show']
}

/*
 *-------------------------------------------------------------------------
 *  DIAGNOSTIC VERB RULES
 *-------------------------------------------------------------------------
 */

/* 
 *  A Verb Rule for going to the object
 *  identified.
 */
VerbRule(ZgotoObj)
    ('zgoto'|'@goto') (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZgotoObjAction
    verbPhrase = '@goto/@goingto (what)'
;

/* 
 *  A Verb Rule for listing the ancestors for the object
 *  identified.
 */
VerbRule(ZlistAncestorObj)
    ('zlist'|'@list') ('ancestor'|'ancestors')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistAncestorObjAction
    verbPhrase = '@list/@listing ancestor (what)'
;

/* 
 *  A Verb Rule for listing the direct extensions for the object
 *  identified.
 */
VerbRule(ZlistChildObj)
    ('zlist'|'@list') ('child'|'children')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistChildObjAction
    verbPhrase = '@list/@listing child (what)'
;

/* 
 *  A Verb Rule for listing the descendants for the object
 *  identified.
 */
VerbRule(ZlistDescendantObj)
    ('zlist'|'@list') ('descendant'|'descendants')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistDescendantObjAction
    verbPhrase = '@list/@listing descendant (what)'
;

/* 
 *  A Verb Rule for listing the first named ancestors for the object
 *  identified.
 */
VerbRule(ZlistFirstNamedAncestorObj)
    ('zlist'|'@list') 'first' 'named' ('ancestor'|'ancestors')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistFirstNamedAncestorObjAction
    verbPhrase = '@list/@listing first named ancestor (what)'
;

/* 
 *  A Verb Rule for listing the first named descendants for the object
 *  identified.
 */
VerbRule(ZlistFirstNamedDescendantObj)
    ('zlist'|'@list') 'first' 'named' ('descendant'|'descendants')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistFirstNamedDescendantObjAction
    verbPhrase = '@list/@listing first named descendant (what)'
;

/* 
 *  A Verb Rule for listing the modifications for the object
 *  identified.
 */
VerbRule(ZlistModObj)
    ('zlist'|'@list') ('mod'|'modification'|'modifications')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistModObjAction
    verbPhrase = '@list/@listing modifications (what)'
;

/* 
 *  A Verb Rule for listing the parents for the object
 *  identified.
 */
VerbRule(ZlistParentObj)
    ('zlist'|'@list') ('parent'|'parents')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZlistParentObjAction
    verbPhrase = '@list/@listing parent (what)'
;

/* 
 *  A Verb Rule for purloining the object that was 
 *  specified.
 */
VerbRule(ZpurloinObj)
    ('zpurloin'|'@purloin') 
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZpurloinObjAction
    verbPhrase = '@purloin/@purloing voc (what)'
;

/* 
 *  A Verb Rule for restoring the state of all 
 *  Thing class instances.
 */
VerbRule(ZrestoreAll)
    ('zrestore'|'@restore') 'all'
    : ZrestoreAllAction
    verbPhrase = '@restore/@restoring all'
;

/* 
 *  A Verb Rule for restoring the state of an object that was 
 *  specified.
 */
VerbRule(ZrestoreObj)
    ('zrestore'|'@restore') 
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZrestoreObjAction
    verbPhrase = '@restore/@restoring (what)'
;

/* 
 *  A Verb Rule for saving the state of all 
 *  Thing class instances
 */
VerbRule(ZsaveAll)
    ('zsave'|'@save') 'all'
    : ZsaveAllAction
    verbPhrase = '@save/@saving all'
;

/* 
 *  A Verb Rule for saving the state of an object that was 
 *  specified.
 */
VerbRule(ZsaveObj)
    ('zsave'|'@save') 
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZsaveObjAction
    verbPhrase = '@save/@saving (what)'
;

/* 
 *  A Verb Rule for showing the action definition of an object that was 
 *  specified.
 */
VerbRule(ZshowActObj)
    ('zshow'|'@show') ('act'|'action'|'actions')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowActObjAction
    verbPhrase = '@show/@showing action (what)'
;

/* 
 *  A Verb Rule for showing the object definition of prop-defined 
 *  properties for the object that was specified.
 */
VerbRule(ZshowDefObj)
    ('zshow'|'@show') ('def'|'definition')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowDefObjAction
    verbPhrase = '@show/@showing definition (what)'
;

/* 
 *  A Verb Rule for showing the state deltas of all 
 *  Thing class instances.
 */
VerbRule(ZshowDeltaAll)
    ('zshow'|'@show') ('delta'|'deltas') 'all' 
    : ZshowDeltaAllAction
    verbPhrase = '@show/@showing delta all'
;

/* 
 *  A Verb Rule for showing the state deltas of an object that was 
 *  specified.
 */
VerbRule(ZshowDeltaObj)
    ('zshow'|'@show') ('delta'|'deltas')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowDeltaObjAction
    verbPhrase = '@show/@showing delta (what)'
;

/* 
 *  A Verb Rule for showing the object definition of directly-defined
 *  properties for the object that was specified.
 */
VerbRule(ZshowDirObj)
    ('zshow'|'@show') (|'dir'|'direct')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowDirObjAction
    verbPhrase = '@show/@showing direct (what)'
;

/* 
 *  A Verb Rule for showing the object property of an object 
 *  that was specified.
 */
VerbRule(ZshowPropObj)
    ('zshow'|'@show') 
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    singleLiteral
    : ZshowPropObjAction
    verbPhrase = '@show/@showing (what) (what)'
;

/* 
 *  A Verb Rule for showing the object state of an object that was 
 *  specified.
 */
VerbRule(ZshowStateObj)
    ('zshow'|'@show') ('state'|'states')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowStateObjAction
    verbPhrase = '@show/@showing state (what)'
;

/* 
 *  A Verb Rule for showing the object definition of non-statically defined
 *  properties for the object that was specified.
 */
VerbRule(ZshowNonStaticObj)
    ('zshow'|'@show') ('nonstat'|'non-static')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZshowNonStaticObjAction
    verbPhrase = '@show/@showing non-static (what)'
;

/* 
 *  A Verb Rule for treeing the ancestor of the object that was 
 *  specified.
 */
VerbRule(ZtreeAncestorObj)
    ('ztree'|'@tree') ('ancestor'|'ancestors')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZtreeAncestorObjAction
    verbPhrase = '@tree/@treeing ancestor (what)'
;

/* 
 *  A Verb Rule for treeing the containment hierarchy for all 
 *  Thing class objects.
 */
VerbRule(ZtreeContAll)
    ('ztree'|'@tree') (|'cont'|'containment') 'all'
    : ZtreeContAllAction
    verbPhrase = '@tree/@treeing containment all'
;

/* 
 *  A Verb Rule for treeing the containment hierarchy of the object that was 
 *  specified.
 */
VerbRule(ZtreeContObj)
    ('ztree'|'@tree') (|'cont'|'containment')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZtreeContObjAction
    verbPhrase = '@tree/@treeing containment (what)'
;

/* 
 *  A Verb Rule for treeing the definer of the object method
 *  that was specified.
 */
VerbRule(ZtreeDefinerObj)
    ('ztree'|'@tree') 'definer'
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZtreeDefinerObjAction
    verbPhrase = '@tree/@treeing definer (what)'
;

/* 
 *  A Verb Rule for treeing the descendant of the object that was 
 *  specified.
 */
VerbRule(ZtreeDescendantObj)
    ('ztree'|'@tree') ('descendant'|'descendants')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZtreeDescendantObjAction
    verbPhrase = '@tree/@treeing descendant (what)'
;

/* 
 *  A Verb Rule for treeing the modifications of the object that was 
 *  specified.
 */
VerbRule(ZtreeModObj)
    ('ztree'|'@tree') ('mod'|'modification'|'modifications')
    (|'voc'->mode_ | 'sym'->mode_ | 'tag'->mode_ )
    singleTopic
    : ZtreeModObjAction
    verbPhrase = '@tree/@treeing modification (what)'
;