#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the PROTEUS, the TADS 3 Utility Classes Package
 *
 *  HtmlTableData.t
 */

#include "html.h"

/*--------------------------------------------------------------------*/
/* 
 *  A base class for HTML Table Data
 */
class HtmlTableData: HtmlTag
{
    tagRoot     = '<td'
    beginTag    = ''
    endTag      = '</td>'

    fontList    = []

    getRowSpan()
    {
        return getHtmlAttributes.getRowSpan();
    }

    setRowSpan(val)
    {
        getHtmlAttributes.setRowSpan(val);
    }

    getColSpan()
    {
        return getHtmlAttributes.getColSpan();
    }

    setColSpan(val)
    {
        getHtmlAttributes.setColSpan(val);
    }

    getAlign()
    {
        return getHtmlAttributes.getAlign();
    }

    setAlign(val)
    {
        getHtmlAttributes.setAlign(val);
    }

    getVAlign()
    {
        return getHtmlAttributes.getVAlign();
    }

    setVAlign(val)
    {
        getHtmlAttributes.setVAlign(val);
    }

    getBgColor()
    {
        return getHtmlAttributes.getBgColor();
    }

    setBgColor(val)
    {
        getHtmlAttributes.setBgColor(val);
    }

    generate()
    {
        beginTag = generateTag();

        say(beginTag);

        for (local i = 1; i <= fontList.length(); ++i)
        {
            fontList[i].generate();

            if (i < fontList.length())
                "<br>";
        }

        say(endTag);
    }

    generateTag()
    {
        local str = '';

        str += tagRoot;

        str += getRowSpan();
        str += getColSpan();
        str += getAlign();
        str += getVAlign();
        str += getBgColor();

        str += '>';

        return str;
    }

    construct(attr, [fList])
    {
        inherited(attr);

        foreach (local font in fList)
        {
            try
            {
                if (dataType(font) == TypeObject && font.ofKind(HtmlTextFont))
                    fontList += font;
            }
            catch(RuntimeError e) {}
        }
    }
}