#charset "us-ascii"

/* 
 *  Copyright (c) 2001-2004 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of PROTEUS, the TADS 3 Utility Classes Package
 *
 *  Proteus.t
 *
 *  Provides a base class for Proteus Exceptions.
 */

/* include the proteus lookup table header */
#include "proteus.h"

/* ------------------------------------------------------------------------ */
/*
 *   The TADS 3 Proteus library Extension ID.
 */
ModuleID
{
    name = 'TADS 3 Proteus Library Extension'
    byline = 'by Kevin L.\ Forchione'
    htmlByline = 'by <a href="mailto:kevin@lysseus.com">Kevin L.\ Forchione</a>'
    version = '1.1.5'

    /*
     *   We use a listing order of 60 so that, if all of the other credits
     *   use the defaults, we appear after the TADS 3 Library's own credits
     *   (conventionally at listing order 50) and before any other extension
     *   credits (which inherit the default order 100), but so that
     *   there's room for extensions that want to appear before us, or
     *   after us but before any default-ordered extensions.  
     */
    listingOrder = 60
} 
 
/* 
 *  A base class for Proteus Exceptions.
 */
class ProteusException: RuntimeError;

/* ------------------------------------------------------------------------ */
/*
 *   global data object for this module
 */
proteusGlobal: object
{
    /* the list of proteus lookup tables */
    proteusLU       = []

    /* the proteus symbol table */
    symbolTableLU   = nil

    /* the proteus snapshot lookup table */
    snapshotLU      = nil

    /* the proteus interface lookup table */
    interfaceLU     = nil

    /* the proteus observables lookup table */
    observableLU    = nil

    /* the proteus observers lookup table */
    observerLU      = nil

    /* the proteus services lookup table */
    serviceLU       = nil

    aHrefMetaCmd    = ('ZshowDirObj'.getPredicate())
}

proteusPreinit: PreinitObject
{
    execBeforeMe = [adv3LibPreinit]

    execute()
    {
        local o;

        o = firstObj(ProteusLU, ObjClasses);
        while (o != nil)
        {
            gProteusLU += o.instantiate();

            o = nextObj(o, ProteusLU, ObjClasses);
        }
    }
}