#charset "us-ascii"
/* 
 *  Copyright (c) 2005 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Services Pack
 *
 *  tsp_delegate_obj.h
 *
 *  TSP Delegate Object Header File
 */
#pragma once
 
/* include the TADS and T3 system headers */
#include "tads.h"
#include "t3.h"
#include "tsp_inheritance_order.h"

/*
 *  Delegates the targetprop to the specified delegation object
 */
#define delegateObj(delObj, args...) \
    DelegateObj.delegateTo(targetobj, delObj, targetprop, args)

/*
 *  Delegates to the specified object and method
 */
#define delegateObjMeth(delObj, method, args...) \
    DelegateObj.delegateTo(targetobj, delObj, method, args)

/*
 *  Delegates the specified method to the inheritedobj
 */
#define delegateMeth(method, args...) \
    DelegateObj.delegateTo(targetobj, inheritedobj, method, args)

enum DelegateRet, DelegateSynch, DelegateNoSynch;