#include <tads.h>

/*
 * An XTads test game.
 * Focus is on abs / % based grid banner sizing.
 */
main(args)
{
	local b0 = nil;
    
    "A banner test game for XTads.\b\b";

    local b1 = bannerCreate(b0, BannerFirst, nil, BannerTypeTextGrid, BannerAlignBottom,
                       50, BannerSizePercent,
                       0);
    bannerSetTextColor(b1, ColorYellow, ColorBlack);
    bannerSay(b1, 'b1 (child of b0) is a horiz grid banner\nbelow b0 sized to 50% of its parent. ');
    "Press a key to continue...\n";
    inputKey();

    local b2 = bannerCreate(b1, BannerFirst, nil, BannerTypeTextGrid, BannerAlignRight,
                       20, BannerSizeAbsolute,
                       0);
    bannerSetTextColor(b2, ColorYellow, ColorBlack);
    bannerSay(b2, 'b2 (child of b1). \nvertical banner \nright of b1, \nand abs width 20.\nno border or scroll bars.\n0123456789012345678901234567890');
    "Press a key to continue...\n";
    inputKey();
    //TODO should \b cause an empty line before 0123...?

    local b3 = bannerCreate(b1, BannerLast, nil, BannerTypeTextGrid, BannerAlignBottom,
                       5, BannerSizeAbsolute,
                       0);
    bannerSetTextColor(b3, ColorYellow, ColorBlack);
    bannerSay(b3, 'b3 (child of b1). horiz banner window below b1, abs height 5.\nline 2\nline 3\nline 4\nline 5\nline 6\nline 7');
    "Press a key to continue...\n";
    inputKey();

    "\bPress another key to exit...\n";
    inputKey();
}

showBannerInfo(win)
{
    local info = bannerGetInfo(win);

    "align = <<info[1]>>, style = <<toString(info[2], 16)>>,
    rows = <<info[3]>>, columns = <<info[4]>>, pixel height = <<info[5]>>,
    pixel width = <<info[6]>>";
}
