# preSLAG.awk v1.0: A GAWK script to aid in converting Invisiclues text files into
# tagged input for the SLAG hint program compiler.
# preSLAG.awk was written by Fredrik Ramsberg on Jan 23, 2003. Released into the
# public domain.

function proc_head() {
  print ".INTRO";
  k=1;
  i=0;
  astrow=0; # asterisk-row, used to delimit different sections of clue file
  step=9;
  spaces=0;
  lastnull=0;
  maxlen=0;
  while(k>0) {
    k = getline;
    if(step==9) {
      if($0~arow) { # Begins with three or more '*'
        astrow+=1;
        if(astrow==2) { # "Invisiclues" head has passed, time for action
          print ".CENTER " substr($0,1,maxlen + 2);
          for(j=0;j<i;j++)
            print ".CENTER " headtext[j];
          print ".CENTER " substr($0,1,maxlen + 2);
          step=0;
        }
      }
      if(astrow==1 && $0!~arow) {
        gsub(/^\* */, "");
        gsub(/ *\* *$/, "");
        headtext[i++]=$0
        if(length($0)>maxlen) maxlen=length($0);
        if($0~/[A-Za-z0-9]/) {
          gsub(/\([tT][mM]\)$/,"");
          if($0~/[a-z]/)
            gamename=$0;
          else
            gamename=substr($0,1,1) tolower(substr($0,2));
        }
          
      }
    }
    else {
      print;
      if(step==1) {
        if($0~/^[ \t]*$/) {
          if(lastnull==0) {
            spaces=spaces+1;
            if(spaces==2) {
              print ".ENDINTRO";
              return;
            }
          }
          lastnull=1;
        }
        else
          lastnull=0;
      }
      if($0~/^Sample Question[ \t]*$/)
        step=1;
    }
  }
}

function print_linebuff() {
  normal_print=1;
  if(hintcount==0 && supermenumode==0) {
    normal_print=0;
    for(i=linecount;i>2 && linebuff[i]~/^[ \t]*$/;i--);
    if(i<=2)
      normal_print=1;
    else {
      gsub(/^\.MENU/,".TEXT",linebuff[1]);
      for(j=1;j<=i && linebuff[j]!~/^[ \t]*$/;j++)
        print linebuff[j];
      print ".FIX";
      for(j=j;j<=i;j++)
        print linebuff[j];
      print ".UNFIX";
      print ".ENDTEXT";
      for(j=i+1;j<=linecount;j++)
        print linebuff[j];
    }
  }
  if(normal_print==1) {
    for(i=1;i<=linecount && i<3;i++)
      print linebuff[i];
    if(hintcount>0)
      print "";
    for(i=1;i<=hintcount;i++)
      print ".LINK " hintname[i];
    if(hintcount>0)
      print "";
    hintcount=0;
    for(i=3;i<=linecount;i++)
      print linebuff[i];
  }
  linecount=0;


}

function proc_body() {
  k=1;
  step=0;
  spaces=0;
  lastnull=1;
  lastline="";
  hintmode=0;
  while(k>0) {
    lastpre="";
    k = getline;
    if(step==1) {
      if($0~arow) {
        lastpre=".MENU ";
        print_linebuff();
        if(tolower(lastline)~/^invisiclues for/) {
          supermenumode=1;
        }
        else if(tolower(lastline)~/table of contents/) {
          lastline="Invisiclues for " gamename;
          supermenumode=1;
        }
        else
          supermenumode=0;
      }
      else if($0~/^ +[A-Z0-9"\-]/) {
        lastpre=".HINT ";
        hintmode=1;
      }
      else if(supermenumode && lastline~/[A-Z] *[a-z+]/) {
        lastpre=".LINK ";
      }
      step=0;
    }
    else if(supermenumode && lastline~/[A-Z] *[a-z+]/)
      lastpre=".LINK ";
    
    
    if(lastnull==1 && $0~/[a-zA-Z0-9]/) {
      step=1;
    }
    else
      step=0;
    if($0~/^[ \t]*$/) {
      lastnull=1;
    }
    else
      lastnull=0;


    linebuff[++linecount]=lastpre lastline;
    if(hintmode==1) {
      hintname[++hintcount]=lastline;
      go_on=1;
      buff="";
      found_alt=0;
      while(go_on) {
        do_print=1;
        newbuff="";
        if($0~/^ +[A-Z]\./) {
          newbuff=substr($0,index($0,".") + 2);
          found_alt=1;
        }
        else if($0~/^ +\-/) {
          newbuff=substr($0,index($0,"-") + 2);
          found_alt=1;
        }
        else if($0~/^[ \t]*$/) {
          lastnull=1;
          go_on=0;
        }
        else if(found_alt==0) {
          i=match($0,/[A-Z0-9a-z"]/);
          if(i>0) {
            newbuff=substr($0,i);
            found_alt=1;
          }
        }
        else {
          buff=buff " " substr($0,index($0,$1));
          do_print=0;
        }
        if(do_print) {
          if(length(buff)>0)
            linebuff[++linecount]=".CLUE " buff;
          buff=newbuff;
        }
        if(go_on) {
          k=getline;
          if(k<1) go_on=0;
        }
      }
      hintmode=0;
    }
    lastline=$0;
  }
}

function proc_file() {
  proc_head();
  proc_body();
}

BEGIN {
  arow="^\\*\\*\\*+$";
  proc_file();
  quit;
}

END {
  print_linebuff();
}