/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx;

import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.mysqlx.ExprParser;
import com.mysql.cj.mysqlx.ExprUtil;
import com.mysql.cj.mysqlx.protobuf.MysqlxCrud;
import com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes;
import com.mysql.cj.mysqlx.protobuf.MysqlxExpr;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class FilterParams {
    private MysqlxCrud.Collection collection;
    private Long limit;
    private Long offset;
    private List<MysqlxCrud.Order> order;
    private MysqlxExpr.Expr criteria;
    private MysqlxDatatypes.Scalar[] args;
    private Map<String, Integer> placeholderNameToPosition;
    protected boolean isRelational;

    public FilterParams(String schemaName, String collectionName, boolean isRelational) {
        this.collection = ExprUtil.buildCollection(schemaName, collectionName);
        this.isRelational = isRelational;
    }

    public FilterParams(String schemaName, String collectionName, String criteriaString, boolean isRelational) {
        this.collection = ExprUtil.buildCollection(schemaName, collectionName);
        this.isRelational = isRelational;
        this.setCriteria(criteriaString);
    }

    public Object getCollection() {
        return this.collection;
    }

    public Object getOrder() {
        return this.order;
    }

    public void setOrder(String orderExpression) {
        this.order = new ExprParser(orderExpression, this.isRelational).parseOrderSpec();
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Object getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String criteriaString) {
        ExprParser parser = new ExprParser(criteriaString, this.isRelational);
        this.criteria = parser.parse();
        if (parser.getPositionalPlaceholderCount() > 0) {
            this.placeholderNameToPosition = parser.getPlaceholderNameToPositionMap();
            this.args = new MysqlxDatatypes.Scalar[parser.getPositionalPlaceholderCount()];
        }
    }

    public Object getArgs() {
        if (this.args == null) {
            return null;
        }
        return Arrays.asList(this.args);
    }

    public void addArg(String name, Object value) {
        if (this.args == null) {
            throw new WrongArgumentException("No placeholders");
        }
        if (this.placeholderNameToPosition.get(name) == null) {
            throw new WrongArgumentException("Unknown placeholder: " + name);
        }
        this.args[this.placeholderNameToPosition.get((Object)name).intValue()] = ExprUtil.argObjectToScalar(value);
    }

    public void verifyAllArgsBound() {
        if (this.args != null) {
            IntStream.range(0, this.args.length).filter(i2 -> this.args[i2] == null).mapToObj(i2 -> this.placeholderNameToPosition.entrySet().stream().filter(e2 -> (Integer)e2.getValue() == i2).map(Map.Entry::getKey).findFirst().get()).forEach(name -> {
                throw new WrongArgumentException("Placeholder '" + name + "' is not bound");
            });
        }
    }

    public void clearArgs() {
        if (this.args != null) {
            IntStream.range(0, this.args.length).forEach(i2 -> {
                this.args[i2] = null;
            });
        }
    }

    public boolean isRelational() {
        return this.isRelational;
    }
}

